; // final detail depends on scale (m) and number of iterations
; // should be yRes^(1/iters), or (yRes / 1.5)^(1/iters) for diagonal lines
;
; // speed depends on number of iterations: .1*iTime is nice for 32 iters
;
; void mainImage( out vec4 o, vec2 u ) {
;   float t = .1*iTime;
;   vec3 m = 1.14 * vec3(cos(t), sin(t), -sin(t));
;   vec2 p = 1. + vec2(sin(t*1.618), sin(t*log(10.)));
;   vec2 q = vec2(0); //p //.2 * vec2(sin(t*.1*log(7.)), sin(t*.1*sqrt(2.)));
;   o.xyz = iResolution;
; //  u = (u+u-o.xy)/o.y + p;
;   u = (u+u-o.xy)/o.y;
;   u = floor(100. * u) / 100.;
;   // 100^(1/16) = 1.333
;   // 100^(1/24) = 1.211
;   // 100^(1/32) = 1.154
;   for(int i=0; i<32; i++) {
;       u = (abs(u) - p) * mat2(m.xzyx);
;   }
;   u = clamp(abs(u),0.,2.);
; //  u = floor(8. * u) / 8.;
;   o = sqrt(vec4(u.y, .5 * (u.x+u.y), u.x, 0)) - .25;
; //  o = vec4(u.y, .5 * (u.x+u.y), u.x, 0);
; }


;vec2 sq(vec2 x) { return x*x; }
;
;void mainImage( out vec4 o, vec2 u ) {
;  float t = .05*iTime;
;  float T = t*3.141592653589;
;  vec3 m = 1.14 * vec3(cos(T), sin(T), -sin(T));
;  vec2 p = sq(vec2(sin(t), sin(t*1.4426950408)));
;  o.xyz = iResolution;
;//  u = (u+u-o.xy)/o.y + p;
;  u = (u+u-o.xy)/o.x;
;  u = floor(100. * u) / 100.;
;  // 100^(1/16) = 1.333
;  // 100^(1/24) = 1.211
;  // 100^(1/32) = 1.154
;  for(int i=0; i<32; i++) {
;      u = (abs(u) - p) * mat2(m.xzyx);
;  }
;  u = clamp(abs(u) * 4.,0.,2.);
;//  u = floor(8. * u) / 8.;
;  o = sqrt(vec4(u.y, .5 * (u.x+u.y), u.x, 0)) - .25;
;//  o = vec4(u.y, .5 * (u.x+u.y), u.x, 0);
;}



org 100h  ; assume al=0 bx=0 si=0x100

  add al,0x13  ;04 13
  cwd          ; dx=0
P add ch,cl
;  shr ch,1     ; ch=G=(R+B)/2 cl=B
  shr cx,1     ; ch=G=(R+B)/2 cl=B/2
  mov bp,dx    ; bp=4 after loop

  int 0x10
  dec bx       ; index++: 255..1 (0 stays black)
  dec dx
  mov ax,0x1010; set palette: bl=index dh=R=0 ch=G cl=B=0xff
U equ $-1 ; U=-32438
TIMESTEP: ;(float32)0.0115
  and dx,0x3c3c; dx= ..RRRR.. ..BBBB..
V equ $-1 ; V=-30404
  mov cx,dx    ; ch=R cl=B
  jnz P
               ; cx=dx=0 bx=0xff00 bp=4

ZOOM equ $-2  ; 1.13
  nop
  aas

  mov bh,0xa0
  mov es,bx

  fldz             ; t=t0
M fsub dword[byte bp-4+si-0x100+TIMESTEP]  ; t-=dt

  fld st0
  fsincos          ; c=cos(t) s=sin(t) t
  fdiv st1,st0     ; c s/c t
  fmul dword[byte bp-4+si-0x100+ZOOM]; c*zoom s/c t
;  fstp dword[si]    ; [si] = c*zoom
;  fstp dword[bp+si] ; [bp+si] = s/c

  fldln2
  fmul st3
  fldlg2
  fmul st4         ; At Bt c*zoom s/c t

I fsin             ; sin(At)               sin(Bt) u s/c t
  fmul st0         ; u=-32438*sin(At)^2    v=-30404*sin(Bt)^2
  fimul word[byte bp-4+si-0x100+U]
  fxch st2         ; c*zoom Bt u s/c t     s/c u v t
  fstp dword[si]   ; [si]=c*zoom           [bp+si]=s/c
  xor si,bp
  jpo I            ; u v t

N mov ax,0xcccd
  mul di
  add dx,bx  ; +a000
  push dx
  push ax    ; [-4]=y, [-5]=x

  fild word[bp-4-4] ; y t
  fild word[bp-4-5] ; x y t

  mov cl,32
L fld st1           ; y x _ u v t       ; x sy _ cy u v t
  fabs
  fadd st4          ; |y|+v x _ u v t   ; |x|+u sy _ cy u v t
  fmul dword[si]    ; cy x _ u v t      ; cx sy _ cy u v t
  fst st2           ; cy x cy u v t     ; cx sy cx cy u v t
  fmul dword[bp+si] ; sy x cy u v t     ; sx sy cx cy u v t
  xor cx,bx
  js L
  faddp st3,st0     ; sy cx cy+sx u v t
  fsubp st1,st0     ; x=cx-sy y=cy+sx u v t
  loop L

  mov cl,2
S fabs
  fistp word[bx]    ; store |x|   ; store |y|
  imul ax,[bx],2
  sbb ah,ch         ; ah-=0: ah=0xff on overflow
  shld word[es:di],ax,4
  pop dx     ; pop twice
  loop S

  inc di
  jnz N

  fcompp

;esc?
  in al,0x60
  cmp al,1
  jne M
  ret
